#!/usr/local/bin/python
#
# NAME
#    pagelink.py
#
# SYNOPSIS
#    python pagelink.py [-d dir] [-r]
#
# DESCRIPTION
#
#    Automatically inserts forward and backward links into the html
#    files entries defined in a file called "index" in the current
#    working directory.  The order of entries in the index file is
#    used to create these links
#
#    Command Flags:
#
#    -r      reverse order specified in the index file
#
#    -d dir  use dir as relative directory on links
#
# NOTES
#
#    Along with the context links, links to the index and the home page are
#    inserted.
#
#    pagelink.py must be run in the directory containing the index file
#    (and html files), otherwise it will exit immediately.
#
#    pagelink.py will detect if links already exist with an html file,
#    and replace them.  It may therefore be run safely many times.
#
#
# MODIFICATION HISTORY
# Mnemonic        Rel  Date   Who
# link.py         1.0  031230 mpw
#    Created
# link.py         1.1  040525 mpw
#    Added HOME and INDEX links in header and footer
# newlink.py      1.3  040612 mpw
#    Revised for html publishing scheme
# pagelink.py      1.4 060304 mpw
#    Renamed to pagelink.py
#
# $Id: pagelink.py,v 1.4 2014/01/03 17:23:22 mark Exp $

import os
import re
import sys
import getopt

def process_file(fn,prev,prev_tag,next,next_tag):
    def buildLinkText(prev,prev_tag,next,next_tag):
        return '<!--linkstart-->'+\
              '<table width="100%" border="0" cellpadding="0" cellspacing="0">'+\
              '<tr><td width="30%" align="left">'+\
              '<a href="'+prev+'">'+'Previous</a></td>'+\
              '<td width="40%" align="center">' +\
              index_link + '</td>' +\
              '<td width="30%" align="right">'+\
              '<a href="'+next+'">Next</a></td></tr>'+\
              '<tr><td width="30%" align="left">'+\
              prev_tag+'</td>'+\
              '<td width="40%" align="center"></td>'+\
              '<td width="30%" align="right">'+\
              next_tag+'</td></tr>'+\
              '</table>'+\
              '<!--linkend-->'
    
    # only use filename portion to open file
    if (fn.rfind("/") > 0):
        fn = fn[fn.rfind("/")+1:]

    try:
        h = open(fn)
    except IOError:
        print fn," - skipping (unable to open)"
        return

    # construct links (table is used to make links flush to margins)
    if reverse_order:
        linktxt = buildLinkText(next,next_tag,prev,prev_tag)
    else:
        linktxt = buildLinkText(prev,prev_tag,next,next_tag)
    html = h.read()
    h.close()
    
    # existing link?
    if (html.find(linktxt) != -1):
        # yes, nothing to do here
        return
    else:
        print "Processing: "+fn
        # remove existing links
        re_link = re.compile(r'<!--linkstart.*?linkend-->')
        html = re_link.sub("",html)
        
    # insert header
    html = linktxt+html
    # replace INDEX link by HOME
    re_index = re.compile(index_link)
    linktxt = re_index.sub(home_link,linktxt)
    # insert footer
    html = html+linktxt
    
    h = open(fn,mode='w')
    h.write(html)
    h.close
    return

#############################################################################
# start here

relpath = ""
reverse_order = False

# check for command line flags
try:
    opts,args =  getopt.getopt(sys.argv[1:],'rd:')
    for o,v in opts:
        if o == '-r': reverse_order = True
        elif o == '-d': 
            # if dir argument, use it to make link relative to httpd root,
            # otherwise have no slash prefix.  This should make the link relative
            # to the current directory, rather than the httpd root.
            relpath = "/"+v+"/"

except getopt.GetoptError,e:
    print >>sys.stderr,sys.argv[0],": illegal flag",e.opt
    sys.exit(1)
    
# expect to run in directory containing journal html files
try:
    f = open("index")
except IOError:
    print "%s: ERROR - index file not found in working directory" % \
          (sys.argv[0])
    sys.exit(1)

re_ce = re.compile(r'(^[ \t]*\#.*$)|(^[ \t]*$)' )
linenum = 1

index_link = '<a href="/cgi-bin/list.py?target='+relpath+'">INDEX</a>'
home_link = '<a href="/index.html">HOME</a>'
index_target = "/cgi-bin/list.py?target="+relpath

for line in f:
    # ignore comments or blank lines
    if (re_ce.match(line)): continue
    token = line.strip().split(":")
    if len(token) != 3:
        print >>sys.stderr,"malformed index record: %s" % (line,)
        sys.exit(1)
    if linenum == 1:
        prev = index_target
        next = index_target
        prev_tag = 'Index'
        next_tag = 'Index'
        cur = relpath+token[1]+".html"
        cur_tag = token[2]
        linenum = linenum+1
        continue
    elif linenum == 2:
        next = relpath+token[1]+".html"
        next_tag = token[2]
        linenum = linenum+1
    else:
        process_file(cur,prev,prev_tag,next,next_tag)
        prev = cur
        prev_tag = cur_tag
        cur = next
        cur_tag = next_tag
        next = relpath+token[1]+".html"
        next_tag = token[2]

# end of index file.  Since we swallowed two records at the start of the
# file, we have to process (completely) the last two records now
# (assuming there are two or more entries, of course)
process_file(cur,prev,prev_tag,next,next_tag)
if linenum>2:
    prev = cur
    prev_tag = cur_tag
    cur = next
    cur_tag = next_tag
    next = index_target
    next_tag = 'Index'
    process_file(cur,prev,prev_tag,next,next_tag)
